<!DOCTYPE html>

<html lang="en">

<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Ola Maps with Reverse Geocoding</title>

    <!-- Include MapLibre GL CSS and JS -->

    <link href="https://unpkg.com/maplibre-gl@latest/dist/maplibre-gl.css" rel="stylesheet" />

    <script src="https://unpkg.com/maplibre-gl@latest/dist/maplibre-gl.js"></script>

    <style>

        #map { height: 500px; width: 100%; }

    </style>

</head>

<body>



    <h2>Select a Location & Adjust Range</h2>

    <input type="text" id="latitude" placeholder="Latitude">

    <input type="text" id="longitude" placeholder="Longitude">

    <input type="text" id="address" placeholder="Address" readonly>

    <input type="number" id="radius" placeholder="Radius (meters)">

    <button onclick="saveData()">Save</button>

    

    <div id="map"></div>

<ul id=blog-list style="width:500px; ">

    </ul>

    <script>

        let map, marker;

        const olaApiKey = "tDhDNdOontnFyzjCD5DNJt1AamjPKZxbWR3Yd4kc"; // Replace with your Ola API Key



        function initMap() {

            const defaultLocation = [78.70755278733425, 10.812215958266693]; // Default: Tiruchirappalli [lng, lat]

            const defaultRadius = 5000; // Default radius in meters



            // Initialize MapLibre Map

            map = new maplibregl.Map({

                container: "map",

                style: `https://api.olamaps.io/tiles/vector/v1/styles/default-light-standard/style.json?api_key=${olaApiKey}`, // Add API key to the style URL

                center: defaultLocation,

                zoom: 13,

                transformRequest: (url, resourceType) => {

                    // Add API key to all requests (only if not already present)

                    if (url.includes("api.olamaps.io") && !url.includes("api_key=")) {

                        return {

                            url: `${url}${url.includes("?") ? "&" : "?"}api_key=${olaApiKey}`,

                            resourceType,

                        };

                    }

                    return { url, resourceType };

                },

            });



            // Add navigation controls

            map.addControl(new maplibregl.NavigationControl());



            // Add Marker

            marker = new maplibregl.Marker({ draggable: true })

                .setLngLat(defaultLocation)

                .addTo(map);



            // Add Circle

            map.on("load", () => {

                // Add a GeoJSON source for the circle

                map.addSource("circle-source", {

                    type: "geojson",

                    data: {

                        type: "FeatureCollection",

                        features: [

                            {

                                type: "Feature",

                                geometry: {

                                    type: "Point",

                                    coordinates: defaultLocation,

                                },

                            },

                        ],

                    },

                });



                // Add a circle layer

                map.addLayer({

                    id: "circle",

                    type: "circle",

                    source: "circle-source",

                    paint: {

                        "circle-radius": {

                            stops: [

                                [0, 0],

                                [20, metersToPixels(defaultRadius, map.getZoom())],

                            ],

                            base: 2,

                        },

                        "circle-color": "#AA0000",

                        "circle-opacity": 0.5,

                        "circle-stroke-width": 1,

                        "circle-stroke-color": "#000000",

                    },

                });



                // Update the circle when the marker is moved

                marker.on("dragend", () => {

                    const newPosition = marker.getLngLat();

                    map.getSource("circle-source").setData({

                        type: "FeatureCollection",

                        features: [

                            {

                                type: "Feature",

                                geometry: {

                                    type: "Point",

                                    coordinates: [newPosition.lng, newPosition.lat],

                                },

                            },

                        ],

                    });

                });

            });



            // Update inputs when the marker is moved

            marker.on("dragend", updateInputs);



            // Update radius when adjusted

            document.getElementById("radius").addEventListener("input", function () {

                const newRadius = parseFloat(this.value);

                if (!isNaN(newRadius)) {

                    map.setPaintProperty("circle", "circle-radius", metersToPixels(newRadius, map.getZoom()));

                }

            });



            // Update circle radius when zoom changes

            map.on("zoom", () => {

                const radius = parseFloat(document.getElementById("radius").value);

                if (!isNaN(radius)) {

                    map.setPaintProperty("circle", "circle-radius", metersToPixels(radius, map.getZoom()));

                }

            });



            updateInputs();

        }



        function updateInputs() {

            const position = marker.getLngLat();

            document.getElementById("latitude").value = position.lat;

            document.getElementById("longitude").value = position.lng;



            // Fetch Address using Ola Reverse Geocode API

            fetchReverseGeocode(position.lat, position.lng);

        }



        function fetchReverseGeocode(lat, lng) {

            const url = `https://api.olamaps.io/places/v1/reverse-geocode?latlng=${lat},${lng}&api_key=${olaApiKey}`;



            fetch(url, {

                headers: {

                    "X-Request-Id": Math.random().toString(36).substring(7), // Unique request ID

                },

            })

                .then((response) => response.json())

                .then((data) => {

                    if (data.results && data.results.length > 0) {

                        document.getElementById("address").value = data.results[0].formatted_address;

                    } else {

                        document.getElementById("address").value = "Address not found";

                    }

                })

                .catch((error) => console.error("Error fetching address:", error));

        }



        function saveData() {

            const lat = document.getElementById("latitude").value;

            const lng = document.getElementById("longitude").value;

            const radius = document.getElementById("radius").value;

            const address = document.getElementById("address").value;



            // Send data to your backend API

            fetch("https://your-backend-api.com/save-location", {

                method: "POST",

                headers: {

                    "Content-Type": "application/json",

                    "X-Request-Id": Math.random().toString(36).substring(7), // Unique request ID

                },

                body: JSON.stringify({

                    latitude: lat,

                    longitude: lng,

                    radius: radius,

                    address: address,

                }),

            })

                .then((response) => response.json())

                .then((data) => {

                    console.log("Location saved:", data);

                    alert("Location saved successfully!");

                })

                .catch((error) => {

                    console.error("Error saving location:", error);

                    alert("Error saving location. Please try again.");

                });

        }



        // Convert meters to pixels based on zoom level

        function metersToPixels(meters, zoom) {

            // Earth's circumference in meters

            const earthCircumference = 40075000;

            // Calculate meters per pixel at the equator for the given zoom level

            const metersPerPixel = earthCircumference / (256 * Math.pow(2, zoom));

            // Convert meters to pixels

            return meters / metersPerPixel;

        }



        window.onload = initMap;

    </script>

    

    <script>

// Function to fetch and display blogs

function fetchAndDisplayBlogs() {

    fetch('https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/getblogs-api.php') // Replace with your actual API endpoint if different

        .then(response => response.json())

        .then(data => {

            if (data.status === 'success') {

                const blogList = document.getElementById('blog-list'); // You'll need to add this ID to your container

                blogList.innerHTML = ''; // Clear existing content



                data.data.forEach(blog => {

                    // Create the blog item HTML

                    const blogItem = document.createElement('li');

                    

                    // Use the first image if available, otherwise use a placeholder

                    const imageUrl = blog.images && blog.images.length > 0 ? 

                                    blog.images[0] : 

                                    'images/client/Hapi Town.png';

                    

                    // Format the date if it exists

                    const formattedDate = blog.pastdate ? 

                                        new Date(blog.pastdate).toLocaleDateString('en-US', { 

                                            year: 'numeric', 

                                            month: 'long', 

                                            day: 'numeric' 

                                        }) : '';

                    

                    blogItem.innerHTML = `

                        <div class="row no-gutters">

                            <div class="col-lg-4 col-md-12 col-sm-12 pd-20">

                                <div class="blog-img">

                                    <img style="background-repeat: no-repeat !important; height:100%; max-width: 100% !important; aspect-ratio: 4 / 3; border-bottom-right-radius: 25px; border-top-right-radius: 25px;" 

                                         src="${imageUrl}" 

                                         alt="${blog.title}" 

                                         class="bg_img">

                                </div>

                            </div>

                            

                            <div class="col-lg-1 col-md-12 col-sm-12"></div>

                            

                            <div class="col-lg-7 col-md-12 col-sm-12">

                                <div class="blog-caption">

                                    <h4 style="font-size:15px; font-weight: 700;">

                                        <a href="#">${blog.title}</a>

                                    </h4>

                                    ${formattedDate ? `<p class="blog-date" style="font-size: 12px; color: #666; margin-bottom: 10px;">${formattedDate}</p>` : ''}

                                    <div class="blog-by" style="text-align: justify;">

                                   <p style="

										font-size: 14px;

										font-weight: 400;

										line-height: 1.7;

										display: -webkit-box;

										-webkit-line-clamp: 3;     /* Show max 3 lines */

										-webkit-box-orient: vertical;

										overflow: hidden;

									">

										${blog.description}  <!-- Remove HTML tags -->

									</p>

                                        <div class="pt-10">

                                            <a href="#" class="btn btn-outline-primary">Read More</a>

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                    `;

                    

                    blogList.appendChild(blogItem);

                });

            } else {

                console.error('Error fetching blogs:', data.message);

                // You might want to display an error message to the user

            }

        })

        .catch(error => {

            console.error('Fetch error:', error);

            // Handle network errors here

        });

}



// Call the function when the page loads

document.addEventListener('DOMContentLoaded', fetchAndDisplayBlogs);

</script>

</body>

</html>